#ifndef MOJEOKNOGL_H
#define MOJEOKNOGL_H

#include "OknoGL.h"
#include "pdb.h"
#include "Wektor.h"

class CMojeOknoGL : public COknoGL
{
	private: 
		void RysujAktorow();		
	//zrodla swiatla
	private:
		void ZrodlaSwiatla();
		void MlecznaZarowka(float jasnosc);
		void ZoltaIZielonaMleczneZarowki();
		void Reflektor(float jasnoscRozblysk=1.0f,float jasnoscRozproszone=0.3f);
	//PDB
	public:
		CMojeOknoGL();
		~CMojeOknoGL();
	private:		
		PDB* pdb;
		bool OpenPDBFile(const char* nazwaPliku);
		void RysujPDB(PDB* pdb,const double jednostkaDlugosci,const double wielkoscAtomuWJednostkachDlugosci,bool koloruj) const;
		void RysujWiazania(PDB* pdb,const double jednostkaDlugosci,bool koloruj) const;
		void WybierzKolorAtomu(const char* symbolPierwiastka,const float alpha) const;
		unsigned int TworzListyWyswietlania(const double jednostkaDlugosci) const;
		LRESULT WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam);
		//wlaczanie/wylaczanie wiezow i sfer
		bool pokazujWiazania;
		float pokazujPDB_rozmiar;
		bool odswiezListyWyswietlania;
		bool typRzutowania; //false=perspektywa,true=izometryczne
		int WyborAtomu(POINT pozycjaKursoraMyszy);
		void RysujZaznaczonyAtom(PDB* pdb,const double jednostkaDlugosci,const double wielkoscAtomuWJednostkachDlugosci,int indeksWskazanegoAtomu,bool uzywajSiatki) const;
		void WyswietlOpisZaznaczonegoAtomu(int indeksWskazanegoAtomu,int czcionkaBitmapowa);
		int indeksWybranegoAtomu;
} okno;

COknoGL* p_okno=&okno;

#endif